@extends('layouts.master')

@section('title')
    تحضير طلاب الصف @isset($classRoom->name)
        {{ $classRoom->name }}
    @endisset في درس @isset($lesson->title)
        {{ $lesson->title }}
    @endisset
@endsection

@section('first-css')
@endsection


@section('content-body')
    <!--**********************************
                            Content body start
                        ***********************************-->
    @include('massages')

    <!-- row -->
    <div class="container-fluid container-fluid-traning bg-white">
        <!--**********************************Tabs Start***********************************-->
        <!--**********************************Tabs End***********************************-->
        <div class="row">
            <div class="col-xl-12 tab-content">
                <form id="studentForm" method="POST" action="{{ route('attendances_store') }}"
                    class="row g-3 fv-plugins-bootstrap5 fv-plugins-framework needs-validation form-disable" novalidate>
                    @csrf
                    <input type="hidden" name="lessonId" value="{{ $lesson->id }}">
                    <input type="hidden" name="classRoomId" value="{{ $classRoom->id }}">
                    <!--**********************************Table AllTransaction Start***********************************-->
                    <div class="tab-pane fade show active" id="AllTransaction" role="tabpanel"
                        aria-labelledby="transaction-tab">
                        <div class="table-responsive fs-14">
                            <table class="table card-table display mb-4 dataTablesCard text-black text-center"
                                id="example">
                                <thead>
                                    <tr>
                                        <th>رقم </th>
                                        <th>اسم المتدرب</th>
                                        <th>تحضير</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @isset($students)
                                        @foreach ($students as $student)
                                            <tr class="odd" role="row">
                                                <td>
                                                    @isset($student->student->id)
                                                        {{ $student->student->id }}
                                                    @endisset
                                                </td>
                                                <td>
                                                    @isset($student->student->name)
                                                        {{ $student->student->name }}
                                                    @endisset
                                                </td>
                                                <td>
                                                    @isset($student->id)
                                                    <div class="checkbox-primary check-lg">
                                                        <input type="checkbox" class="form-check-input" name="subscribes[]" value="{{ $student->id }}" checked="" id="customCheckBox9" >
                                                    </div>
                                                    @endisset
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endisset
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--**********************************Table AllTransaction End***********************************-->
                    <button type="submit" class="btn btn-primary me-sm-3 me-1 form-btn-disable">تحضير</button>
                </form>
            </div>
        </div>
    </div>

    <!--**********************************
                            Content body end
                ***********************************-->
    @include('students.modals.new')

@endsection
@section('script')
@endsection
